setwd("F:\\Wokspace\\C19\\SDL\\Step2\\Pandemiav2.2[1.7]\\data\\traces")
require(XML)
data <-xmlParse("Pandemia (2020-06-10 1749h).trace.xml")
xTime <-xpathSApply(data, "//Events/EYE_Report/@xTime")
agent <-xpathSApply(data, "//Events/EYE_Report/@agent")
varname <-xpathSApply(data, "//Events/EYE_Report/@varname")
vartype <-xpathSApply(data, "//Events/EYE_Report/@vartype")
varvalue <-xpathSApply(data, "//Events/EYE_Report/@varvalue")
label <-xpathSApply(data, "//Events/EYE_Report/@label")
cell<-xpathSApply(data, "//Events/EYE_Report/@cell")

if (length(cell)>0) {
  report_values<-data.frame(xTime, agent, varname, vartype, varvalue, label, cell)
} else report_values<-data.frame(xTime, agent, varname, vartype, varvalue, label)

xTime_array <-xpathSApply(data, "//Events/EYE_ReportArray/@xTime")
agent_array <-xpathSApply(data, "//Events/EYE_ReportArray/@agent")
varname_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varname")
vartype_array <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype")
varvalue_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue")
label_array <-xpathSApply(data, "//Events/EYE_ReportArray/@label")
varname_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varname_label")
vartype_label <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype_label")
varvalue_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue_label")
report_array_values<-data.frame(xTime_array, agent_array, varname_label, vartype_label, varvalue_label, varname_array, vartype_array, varvalue_array, label_array)

library('plotly')
library('htmlwidgets')

all_reports<-unique(report_values$varname[report_values$vartype!="char*"])

if (length(cell)>0) {
  
 for (report in all_reports) {
   
    path<-getwd()
    initializeCellsPath<-paste(path,"/../Initialize.img",sep="")
    etiquetes<-read.table(initializeCellsPath)
    
    values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
    time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
    report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
    
    dataframe <-data.frame(time, report_cell, values)
    write.csv2(x = dataframe[order(dataframe$report_cell),], file = paste(report,".csv",sep=""))
    
    cell_position=0
    report_by_cell<-dataframe[dataframe$report_cell==cell_position,]
    cellName<-etiquetes$V1[cell_position+1]
    
    report_cell_name<-paste(cellName,paste(report,paste(paste("Cell",cell_position))))
    
    grafica1 <- plot_ly(report_by_cell, x = report_by_cell$time, y = report_by_cell$values, type = 'scatter', mode = 'lines', name=report_cell_name)

    n_length<-as.numeric(as.character(unique(cell)[-1]))
    for (i in n_length) {
      cellName<-etiquetes$V1[i+1]
      report_cell_name<-paste(cellName,paste(report,paste(paste("Cell",i))))
      grafica1 <- add_trace(grafica1, x = dataframe[dataframe$report_cell==i,]$time,y = dataframe[dataframe$report_cell==i,]$values, name = report_cell_name, line = list(color = 'rgb(22, 96, 167)', width = 2)) 
    }
       
    grafica1 %>% layout(title = report_cell_name,
         xaxis = list(title = "Time"),
         yaxis = list (title = report))
     grafica <- paste(report,"_plotly.html",sep="")
    
    htmlwidgets::saveWidget(as_widget(grafica1), grafica,selfcontained = FALSE)
  }
  
} else {
  
  for (report in all_reports) {
    values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
    time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
    dataframe<-data.frame(time,values)
    
    write.csv2(x = dataframe, file = paste(report,".csv",sep=""))
    
    grafica1 <- plot_ly(dataframe, x = ~dataframe$time, y = ~dataframe$values, type = 'scatter', mode = 'lines', name=paste(report))
        
    grafica1 %>% layout(title = report,
         xaxis = list(title = "Time"),
         yaxis = list (title = report))
         
    grafica <- paste(report,"_plotly.html",sep="")
    htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)
  }
  
}

